<?php
/**
 * Queue Cleaner for BitrixAI
 * 
 * This script clears unprocessed messages in the database and message queues.
 * It's useful to run this when you need to reset the system and clear pending messages.
 */

// Clear messages in the SQLite database
$dbPath = __DIR__ . "/database/messages.db";
try {
    if (file_exists($dbPath)) {
        echo "Clearing SQLite database messages...\n";
        $db = new PDO("sqlite:$dbPath");
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Mark all messages as processed
        $stmt = $db->prepare("UPDATE messages SET processed = 1, processing = 0");
        $stmt->execute();
        
        $rowsAffected = $stmt->rowCount();
        echo "Successfully marked $rowsAffected messages as processed in SQLite database.\n";
    } else {
        echo "SQLite database not found at $dbPath. Skipping SQLite cleanup.\n";
    }
} catch (PDOException $e) {
    echo "Database error: " . $e->getMessage() . "\n";
}

// Clear queue JSON files
$queueFiles = [
    __DIR__ . "/message_queue.json",
    __DIR__ . "/public/message_queue.json",
    __DIR__ . "/webhook_message_queue.json"
];

foreach ($queueFiles as $queueFile) {
    if (file_exists($queueFile)) {
        echo "Clearing queue file: $queueFile\n";
        file_put_contents($queueFile, '[]');
    }
}

// Reset buffer storage
$bufferFile = __DIR__ . "/buffer_storage.json";
if (file_exists($bufferFile)) {
    echo "Resetting buffer storage...\n";
    file_put_contents($bufferFile, '{"messages": []}');
}

echo "Queue cleanup completed successfully.\n"; 