# PowerShell script to start BitrixAI services in separate windows

# --- Configuration ---
$phpExe = "php.exe" # Assumes php.exe is in your PATH. Use full path if necessary.
$processorScript = ".\direct_message_processor.php"
$webhookScript = ".\chatapp_webhook.php"
$listeningIp = "0.0.0.0"
$webPort = "8080"
$numProcessors = 3 # Number of processor instances

# --- Validate PHP ---
Write-Host "Validating PHP path..."
$phpPath = Get-Command $phpExe -ErrorAction SilentlyContinue
if (-not $phpPath) {
    Write-Error "ERROR: Cannot find '$phpExe'. Please ensure PHP is installed and in your PATH, or adjust the `$phpExe variable in this script."
    Read-Host "Press Enter to exit"
    exit 1
}
Write-Host "PHP found at: $($phpPath.Source)"

# --- Start Processors ---
Write-Host "Starting $numProcessors processor instances in separate windows..."
for ($i = 1; $i -le $numProcessors; $i++) {
    Write-Host "  Starting processor instance $i..."
    $processorArgs = @($processorScript)
    # Start-Process launches the command in a new window by default
    Start-Process -FilePath $phpExe -ArgumentList $processorArgs
    # Add a small delay to allow window creation and initial output
    Start-Sleep -Seconds 1
}
Write-Host "Processor instances launched."

# --- Start Web Server ---
Write-Host "Starting PHP web server for '$webhookScript' on $listeningIp`:$webPort in a separate window..."
$webServerArgs = @("-S", "$listeningIp`:$webPort", $webhookScript)
Start-Process -FilePath $phpExe -ArgumentList $webServerArgs

Write-Host "Web server launched."

# --- Completion Message ---
Write-Host "`n============================================================="
Write-Host " BitrixAI Services Launched (PowerShell)"
Write-Host "============================================================="
Write-Host "`n  - $numProcessors processor instances launched in separate windows."
Write-Host "  - Web server for '$webhookScript' launched in a separate window."
Write-Host "`n  NOTE: Monitor the individual PowerShell windows for logs and output."
Write-Host "`n  To STOP the services: Close each of the new PowerShell windows that opened."
Write-Host "`n"
Read-Host "Press Enter after reviewing the new windows. This script window will then close." 