<?php
// Include just the BitrixApiHelper class
require_once 'bitrix24/BitrixApiHelper.php';

// Create an instance of the BitrixApiHelper
$apiHelper = new BitrixApiHelper();

// Define the deal data with company information that doesn't exist yet
$dealData = [
    // Product information
    'product' => 'New Product',
    'arabic_product' => 'منتج جديد',
    'quantity' => '750',
    
    // New Company information (doesn't exist yet)
    'company' => 'New Test Company LLC',
    'arabic_company' => 'شركة اختبار جديدة',
    
    // Location information
    'city' => 'Riyadh', 
    'arabic_city' => 'الرياض',
    
    // Client information
    'client_name' => 'Abdullah Mohammed',
    'arabic_client_name' => 'عبدالله محمد',
    'email' => 'abdullah@example.com',
    'phone' => '+966512345678'
];

// Define a deal ID that we know doesn't have a company
// NOTE: Replace this with an actual deal ID from your Bitrix24 instance
$dealId = 225421; // Use your test deal ID here 

// Update the deal
echo "Updating deal $dealId with data that should create a new company if needed...\n";
$result = $apiHelper->updateDeal($dealId, $dealData);

// Display the result
if (isset($result['result']) && $result['result']) {
    echo "Success! Deal updated with company and contact information.\n";
    
    // Check if logs indicate a company was created
    $logsDir = __DIR__ . '/bitrix24/logs';
    if (file_exists($logsDir . '/deals.log')) {
        $logContent = file_get_contents($logsDir . '/deals.log');
        if (strpos($logContent, 'Creating new company') !== false) {
            echo "Company creation was attempted (check logs for details).\n";
        }
        if (strpos($logContent, 'Successfully created company') !== false) {
            echo "Company was successfully created (check logs for confirmation).\n";
        }
    }
} else {
    echo "Failed to update deal.\n";
    echo "Error: " . (isset($result['error']) ? $result['error'] : 'Unknown error');
} 