<?php
// Include the necessary classes
require_once 'bitrix24/BitrixApiHelper.php';
require_once 'bitrix24/MessageHandler.php';
require_once 'bitrix24/MessageHandlerExtension.php';

// Create an instance of the BitrixApiHelper
$apiHelper = new BitrixApiHelper();

// Create a configuration array
$config = [
    'bitrix24' => [
        'webhook_url' => 'https://youmats.bitrix24.com/rest/1/b8flxxfaq10oo3ql/'
    ],
    'polling' => [
        'interval' => 30,
        'store_days' => 7
    ],
    'webhook' => [
        'forward_url' => 'http://localhost:8080/webhook.php'
    ]
];

// Initialize a database connection
try {
    // Use PDO with SQLite
    $dbPath = __DIR__ . '/database/messages.db';
    $db = new PDO("sqlite:{$dbPath}");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Create an instance of the MessageHandlerExtended with required parameters
$messageHandler = new MessageHandlerExtended($apiHelper, $config, $db);

// Define a sample JSON message from OpenAI with deal information
$jsonMessage = <<<JSON
{
  "metadata": {
    "type": "deal_update",
    "confirmed": true
  },
  "product": "Concrete Blocks",
  "arabic_product": "كتل خرسانية",
  "company": "ABC Construction",
  "arabic_company": "شركة ABC للإنشاءات",
  "city": "Jeddah",
  "arabic_city": "جدة",
  "quantity": "500",
  "client_name": "Mohammed Abdullah",
  "arabic_client_name": "محمد عبدالله"
}
JSON;

// Create a mock message that would come from OpenAI Assistant
$mockMessage = [
    'id' => 'test_' . time(),
    'dialog_id' => 'chat232835', // Using the dialog ID from the example
    'message_text' => "I've analyzed your request and here's the deal information:\n\n```json\n$jsonMessage\n```\n\nI'll update your deal with these details.",
    'entity_data_1' => 'Y|DEAL|225421|N|N|172433|1744549392|0|0|0',
    'entity_data_2' => 'LEAD|0|COMPANY|0|CONTACT|81993|DEAL|225421'
];

// Process the message
echo "Processing deal information message...\n";
$result = $messageHandler->processDealInformation($mockMessage);

// Display the result
if ($result) {
    echo "Success! Deal information was processed successfully.\n";
} else {
    echo "Failed to process deal information.\n";
    
    // Check the logs
    $logFile = __DIR__ . '/bitrix24/logs/deals.log';
    if (file_exists($logFile)) {
        echo "\nLast 5 log entries:\n";
        $logs = file($logFile);
        $lastLogs = array_slice($logs, -5);
        echo implode("", $lastLogs);
    }
    
    $errorLogFile = __DIR__ . '/bitrix24/logs/errors.log';
    if (file_exists($errorLogFile)) {
        echo "\nError log entries:\n";
        $logs = file($errorLogFile);
        $lastLogs = array_slice($logs, -5);
        echo implode("", $lastLogs);
    }
} 