<?php
// Include just the BitrixApiHelper class
require_once 'bitrix24/BitrixApiHelper.php';

// Create an instance of the BitrixApiHelper
$apiHelper = new BitrixApiHelper();

// Define the deal data with more detailed contact and company information
$dealData = [
    // Product information
    'product' => 'Concrete Blocks',
    'arabic_product' => 'كتل خرسانية',
    'quantity' => '500',
    
    // Company information
    'company' => 'ABC Construction',
    'arabic_company' => 'شركة ABC للإنشاءات',
    
    // Location information
    'city' => 'Jeddah', 
    'arabic_city' => 'جدة',
    
    // Client information
    'client_name' => 'Mohammed Abdullah',
    'arabic_client_name' => 'محمد عبدالله',
    'email' => 'mohammed@example.com',
    'phone' => '+966501234567'
];

// Define the deal ID from the example
$dealId = 225421;

// Update the deal
echo "Updating deal $dealId with contact and company information...\n";
$result = $apiHelper->updateDeal($dealId, $dealData);

// Display the result
if (isset($result['result']) && $result['result']) {
    echo "Success! Deal, contact, and company information were updated successfully.\n";
    
    // Test extracting deal ID from entity data
    $entityData1 = 'Y|DEAL|225421|N|N|172433|1744549392|0|0|0';
    $entityData2 = 'LEAD|0|COMPANY|0|CONTACT|81993|DEAL|225421';
    
    $extractedId1 = $apiHelper->extractDealId($entityData1);
    $extractedId2 = $apiHelper->extractDealId($entityData2);
    
    echo "Extracted deal ID from entity_data_1: $extractedId1\n";
    echo "Extracted deal ID from entity_data_2: $extractedId2\n";
    
    // Extract contact ID from entity data for verification
    if (preg_match('/CONTACT\|(\d+)/', $entityData2, $matches)) {
        echo "Associated contact ID: {$matches[1]}\n";
    }
} else {
    echo "Failed to update deal.\n";
    echo "Error: " . (isset($result['error']) ? $result['error'] : 'Unknown error');
} 